#include<iostream.h>
#include<stdlib.h>
#include<time.h>
#include<conio.h>

#include "queue.h"

const int Total_Minutes=1440;

class McDonalds
{
	private:
		List<int> Customer;
		int Customer_Id;
		int Arrival_Time;
		int Current_Service_Time;
		int Hour_Waiting_Time;
		int Total_Customers;

	public:

		McDonalds() : Customer_Id(0) , Arrival_Time(0), Hour_Waiting_Time(0) , Current_Service_Time(0),						
					  Total_Customers(0)
		{ }

		void Simulation(ofstream&);						
};

void McDonalds::Simulation(ofstream& outFile)
{
	int Customer_Arrival_Time=1, Total_Waiting=0 , Service_Time=0 ,j=0;			
	float Average_Waiting_Time=0;
	
	Arrival_Time=1;

	srand(time(0));			
				
	for (int minute=1 ; minute<=Total_Minutes ; minute+=Customer_Arrival_Time)
	{	
		if (minute==Arrival_Time)
		{
			++Customer_Id;
			Current_Service_Time=(rand()%4+1) + 4;														
			Customer.Insert_Node(Customer_Id,Customer_Arrival_Time,Current_Service_Time);																		

			Service_Time+=Current_Service_Time;

			if (Service_Time>1440)
				break;
			else
				Hour_Waiting_Time+=Current_Service_Time-Customer_Arrival_Time;
						
			Arrival_Time=(rand()%3+1)+minute;
			Customer_Arrival_Time=Arrival_Time-minute;									
		}													
	}					

	
	Total_Customers+=Customer_Id;				
	Total_Waiting+=Hour_Waiting_Time;	
	
	Average_Waiting_Time=Total_Waiting/Customer_Id;

	outFile<<"--------------------------------------------------------------"<<endl;
	outFile<<"                    M C D O N A L D S "<<endl;
	outFile<<"--------------------------------------------------------------"<<endl;
	outFile<<"            2 4  -  H o u r  S i m u l a t i o n"<<endl;
	outFile<<"--------------------------------------------------------------"<<endl<<endl;
	outFile<<"=> TOTAL CUSTOMERS	: "<<Customer_Id<<endl<<endl;
	outFile<<"=> TOTAL WAITING TIME (in minutes) : "<<Total_Waiting<<endl<<endl;
	outFile<<"=> TOTAL WAITING TIME (in hour)	: "<<Total_Waiting/60<<endl<<endl;
	outFile<<"=> AVERAGE WAITING TIME (per customer): "<<Average_Waiting_Time<<endl<<endl;
	outFile<<"--------------------------------------------------------------"<<endl<<endl;

	if ((Average_Waiting_Time)>3)
		outFile<<"The management has to increase the number of counters"<<endl<<endl;
	else
		outFile<<"The management need not increase the number of counters"<<endl<<endl;

	outFile<<"--------------------------------------------------------------"<<endl;

	Customer.Display_List(outFile);	

}

int main(int argc , char* args[])
{
	if (argc<1)
	{
		cerr<<"INVALID NUMBER OF ARGUMENTS";
		return 1;
	}		
	
	//open file stream for the input and output	
	ofstream outFile(args[1], ios::out);

	//checks that the output file is open or not
	if (!outFile)
	{
		cerr<<"unable to open the output file"<<endl;
		return 2;
	}	

	McDonalds Customers;

	Customers.Simulation(outFile);

	return 0;
}

